#include <amxmodx>
#include <amxmisc>

#define PLUGIN "Game Menu"
#define VERSION "1.2.1"
#define AUTHOR "-=eXclass=-"

#define GAMEMENU_FILE "resource/GameMenu.res"
#define MAX_SIZE 1012

new g_Text[MAX_SIZE]
new GameMenu[34]

new keysmenu = (1<<0)|(1<<1)|(1<<2)|(1<<3)|(1<<4)|(1<<5)|(1<<6)|(1<<7)|(1<<8)|(1<<9)

public plugin_init() 
{
    register_plugin(PLUGIN, VERSION, AUTHOR)

    register_clcmd("say /setmenu", "cmd_setmenu")
    register_clcmd("say_team /setmenu", "cmd_setmenu")
    register_clcmd("say /servers", "cmd_setmenu")
    register_clcmd("say_team /servers", "cmd_setmenu")
    register_menu("Menu", keysmenu, "Submenu")

    register_dictionary("gm.txt")

    set_task(0.1, "Read_GameMenu")
}

public Read_GameMenu()
{
    new i_File, s_File[128], Len, i
    
    // Получаем путь к директории с конфигами AMXX в s_File.
    get_configsdir(s_File, charsmax(s_File))
    
    // Формируем путь к gamemenu.txt файлу, используя путь к конфигам, и сохраняем в s_File.
    format(s_File, charsmax(s_File), "%s/gamemenu.txt", s_File)
    
    // Открываем файл для чтения
    i_File = fopen(s_File, "r")
    
    // Читаем содержимое файла в g_Text. Данная функция поддерживает чтение символов CR, LF.
    fgets(i_File, g_Text, MAX_SIZE)
    
    // Закрываем файл
    fclose(i_File)

    md5_file(s_File, GameMenu)
    Len = strlen(GameMenu)
    for (i = 4; i < Len-1; i++) GameMenu[i] = 0
}

public cmd_setmenu(id)
{
    // Указываем путь к файлу resource/GameMenu.res
    client_cmd(id, "motdfile %s", GAMEMENU_FILE)
    
    // Записываем в файл содержимое g_Text
    client_cmd(id, "motd_write %s", g_Text)
    
    // Возвращаем значение команды по умолчанию
    client_cmd(id, "motdfile motd.txt") 

    client_print(id, print_chat, "[AMXX] %L", id, "OK")
}

public client_authorized(id)
   set_task(20.0, "info", id)
	
public info(id)
    client_print(id, print_chat, "[AMXX] %L", id, "SETMENUCMD")

public plugin_precache()
{
    precache_generic("resource/GameMenu.tga");
    return PLUGIN_HANDLED
}

public client_putinserver(id)
{
   set_task(2.0, "Menu", id)
}

public Menu(id)
{
	static menu[500], len
	len = 0

        if(is_user_connected(id))
	{
		len += formatex(menu[len], charsmax(menu) - len, "\yДобавить наши сервера в меню^nдля быстрого подключения?^n^n")
		
		len += formatex(menu[len], charsmax(menu) - len, "\r1. \wДобавить^n")

		len += formatex(menu[len], charsmax(menu) - len, "\r2. \wНичего не делать^n^n")
		
		show_menu(id, keysmenu, menu, -1, "Menu")
	        }

}

public Submenu(id, key)
{
            switch(key)
	    {
                case 0:
		{
                    client_cmd(id, "say /setmenu")
		}
                case 1:
		{
                    ///
		}
	}
} 
    